#include <HT66F019.H>
/*----------------------------------------------------------------------------
 * Name     : rf_ap.c
 * Purpose  : RF binding functions
 * Note(s)  : 
 *---------------------------------------------------------------------------- */

#include "string.h"
#include "rf_ap.h"


#define	ADV_CHANNEL				(HOP_FNO)

u8	tmp_buf[6];
u16 timeout_cnt;
extern u8 RF_mode;

u8 IsCatchAdv; //kokutou

static adv_pdu_struct AdvPayload	__attribute__ ((at(0x180)));
static adv_pdu_struct RspPayload	__attribute__ ((at(0x1a8)));

uc8 __attribute__ ((at(0x1FD0))) demoboardAdvData[][6]=
{
	{'B','C','7','2','6','2'},
};

uc8 __attribute__ ((at(0x1FE0))) phoneAdvData[][6]=
{
	{'B','e','a','c','o','n'},
	{0x02,0x03,0xBC,0x72,0x62},	
};


uc8 __attribute__ ((at(0x1FF0))) access_addr[][4]=
{
	{	0xD6, 0xBE, 0x89, 0x8E	},
};

uc8 __attribute__ ((at(0x1FF8))) device_addr[][6]=
{
	{	0x31,0x32,0x33,0x34,0x35,0x36	},
};

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void set_rf_tx1_data(u8 len, u8 *dta)
{
	AdvPayload.header.bits.length = len + ADV_ADDR_SIZE;
	RspPayload.header.bits.txadd = 0;
	RspPayload.header.bits.rxadd = 0;
	memcpy((void *)AdvPayload.adv_data, (void *)dta, len);
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
u8 rf_mode(void)
{
	return RF_mode;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
u8 ReadRxData(u8 *buf)
{
	int i = 0;
	BC7262_ReadPDUFIFO(&AdvPayload, FIFO0, RECEIVER_DATA);
    for(i=0;i<31;i++)
	{
		buf[i] =  AdvPayload.adv_data[i];
	}
	IsCatchAdv = Is_same(&AdvPayload.adv_data[5],&phoneAdvData[0][0],6);
	return IsCatchAdv;	
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
adv_pdu_struct *GetBuffPtr(void)
{
	return &AdvPayload;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
u8	GetPorFlag(void)
{
	u8	dta;
	
	BC7262_WakeUp();
	BC7262_ReadRegister(DIR_CTRL_REQ, &dta);
	BC7262_WriteRegister(DIR_CTRL_REQ, dta & 0x7F);
	
	return (dta & 0x80);
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void NoConnTX(u8 *macaddr)
{
	pkt_ctl_t	regv;
	u8	pdu_length;
	int i;
	
	BC7262_ReadRegister(PKT_CTL_REG, &regv.value);
	regv.bits.bkmode = BROADCASTER;
	regv.bits.fifo_sel = FIFO0;
//	regv.bits.pmlen = ONE_BYTE_PRM;
	BC7262_WriteRegister(PKT_CTL_REG, regv.value);
	
	memcpy((void *)tmp_buf, access_addr[0], sizeof(access_addr[0]));
    BC7262_WriteRegister(PDU_PTR_REG,0x80);//reset FIFO pointer	
     
//	pdu_length = sizeof(ble_adv_pdu)+ADV_ADDR_SIZE;
	AdvPayload.header.bits.type = ADV_NONCONN_IND;
	pdu_length = AdvPayload.header.bits.length;
//	AdvPayload.header.bits.length = pdu_length;
    for(i=0;i<6;i++)
    {
     AdvPayload.adv_addr[i] =  macaddr[i]; 	
    }
//	memcpy(AdvPayload.adv_data, ble_adv_pdu, sizeof(ble_adv_pdu));
	
//	BC7262_LightSleep();
//	BC7262_AdvStop(ADV_CHANNEL);
	
	BC7262_WriteAccAddr((u8 *)tmp_buf);
		
	BC7262_WriteHeader(0, (u8 *)&AdvPayload.header.value);
	BC7262_WriteDevAddr((u8 *)AdvPayload.adv_addr);
	BC7262_WritePDUFIFO((u8 *)AdvPayload.adv_data, pdu_length-ADV_ADDR_SIZE);
     
	BC7262_TXAdvStart(ADV_CHANNEL);
	RF_mode = TX_MODE;
	
//	timeout_cnt=TIMEOUT_COUNTER;
//	_cton=TRUE;	
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void NoConnRX(u8 RXchannel)
{
	pkt_ctl_t	regv;
	wht_flt_t	flt;
	u8 RxChannel;
	memcpy((void *)tmp_buf, access_addr[0], sizeof(access_addr[0]));
	BC7262_LightSleep();
	BC7262_WriteAccAddr((u8 *)tmp_buf);	
	BC7262_ReadRegister(PKT_CTL_REG, &regv.value);
	regv.bits.bkmode = OBSERVER;
	regv.bits.fifo_sel = FIFO0;
	regv.bits.pdud_rs = 1;
//	regv.bits.pmlen = ONE_BYTE_PRM;
	BC7262_WriteRegister(PKT_CTL_REG, regv.value);
	
	BC7262_WriteRegister(PDU_PTR_REG,0x80);//reset FIFO pointer	
	flt.value = 0x00;
	BC7262_WriteRegister(FLT_CTL_REG, flt.value);
	

			
	BC7262_RXAdvStart(RXchannel);
	RF_mode = RX_MODE;
	
//	timeout_cnt=RX_TIMEOUT;
//	_cton=TRUE;	
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
u8 Is_same(u8 *saddr,u8 *taddr,u8 len)
{	
	while(len)
	{
		if(*saddr != *taddr) return(FALSE);
		saddr++;
		taddr++;
		len--;
	}
	return TRUE;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void BeaconSend(u8 keystatus,u8 *macaddr, u8 len, u8 *dta)
{			 
  set_rf_tx1_data(len,dta);	
  AdvPayload.adv_data[20]=keystatus;  
  BC7262_WakeUp();
  NoConnTX(macaddr);
}
